﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Configuration;
using System.Web.UI;

using Microsoft.Reporting.WebForms;

using VIRP.EFR.UTIL;
using VIRP.CRS.BO;
using VIRP.EFR.BO;
using VIRP.CRS.BLL;
using VIRP.EFR.BLL;

namespace VIRP_WEB.Custom.EFR
{
    public partial class LabResultsInterpretationLetters : EfrBasePage
    {
        private class LabResultsInterpretationLettersParameters
        {
            internal string ActivityID { get; }
            internal string IntActivityID { get;  }
            internal string ReportType { get; }
            internal bool BatchReport { get; }
            internal int? CaseID { get; }

            internal LabResultsInterpretationLettersParameters(HttpRequest request)
            {
                this.ActivityID = request.QueryString["activityId"].ToString();
                this.IntActivityID = request.QueryString["intActivityId"].ToString();
                this.ReportType = request.QueryString["RptType"].ToString();
                this.BatchReport = (this.ActivityID == "0");
                this.CaseID = StringUtility.TryGetValueFromString<int>(request.QueryString["CaseId"]);
            }
        }

        // Defaults
        private const string PrintDefaults = "PDF;WORDOPENXML";
        private string BatchPrintOptions = PrintDefaults;
        private string IndividualPrintOptions = PrintDefaults;

        private static IReadOnlyList<string> navigationSources = new List<string>
        {
            "/Custom/EFR/InterpretationAndFollowUp/LabResultsInterpretation.aspx",
            "/Custom/EFR/InterpretationAndFollowUp/BioLabInterpretation.aspx",
            "/Custom/EFR/InterpretationAndFollowUp/FragLabInterpretation.aspx",
            "/Custom/EFR/InterpretationAndFollowUp/FragLabInterpretationFragment.aspx",
            "/Custom/EFR/Patients/PatientWorkflows.aspx"
        };

        private readonly LabResultsInterpretationManager labResultsInterpretationManager;
        private readonly ReportViewerHandler reportViewerHandler;

        public LabResultsInterpretationLetters()
        {
            labResultsInterpretationManager = new LabResultsInterpretationManager();
            reportViewerHandler = new ReportViewerHandler();

            NavigationSources = navigationSources;
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            var letterParams = new LabResultsInterpretationLettersParameters(Request);
            string breadCrumb = "";

            if (!Page.IsPostBack)
            {
                GetPrintOptions();

                // Set print options for JS
                Session["batchReport"] = SessionItemFactory.Create(letterParams.BatchReport.ToString());
                Session["EFRBatchPrintOptions"] = SessionItemFactory.Create(BatchPrintOptions);
                Session["EFRIndividualPrintOptions"] = SessionItemFactory.Create(IndividualPrintOptions);

                if (letterParams.BatchReport)
                {
                    SetBreadCrumbLabelForBatchReport(letterParams);
                    Session["PrintCompletedLetters"] = true;
                }
                else
                {
                    WKF_CASE wCase = labResultsInterpretationManager.GetLabInterpretationDetails(CurrentUser, CurrentRegistryId, letterParams.CaseID.Value);

                    HiddenFieldCaseTypeID.Value = wCase.STD_WKFCASETYPE_ID.ToString();
                    STD_WKFACTIVITYSTS activityStatus;

                    var activity = WKF_CASE_ACTIVITYManager.GetitemsByWorkflowCaseId(CurrentUser, CurrentRegistryId, wCase.WKF_CASE_ID)
                        .Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation))
                        .FirstOrDefault();

                    // If this is called by unaccepting lab results, and while they are unaccepted, clicking on the 'Patient/Provider Interpretation letter Archived'
                    // there will be an error because there are no 'Interpretion' wkf_case_activity entries in Intepreted status. Try again w/o that restriction
                    if (activity != null)
                    {
                        activityStatus = activity.STD_WKFACTIVITYSTS;
                        breadCrumb = "Interpretation & Follow Up > " + activityStatus.NAME + " > Workflow ID " + wCase.WKF_CASE_ID;
                    }
                    else
                    {
                        // Assume "In Progress"
                        breadCrumb = "Interpretation & Follow Up > In Process > Workflow ID " + wCase.WKF_CASE_ID;
                    }

                    if (letterParams.ReportType == "0") //Patient
                        breadCrumb += " > Patient Letter";
                    if (letterParams.ReportType == "1") //Provider
                        breadCrumb += " > Provider Letter";

                    ReplacePageTitle(breadCrumb);
                }

                SetReferringPage();
                SetupReport(letterParams);
            }
        }

        private void GetPrintOptions()
        {
            var batchPrintOptionsSetting = SETTINGSManager.GetItemByRegistryName(CurrentUser, CurrentRegistryId, "EFRBatchPrintOptions");
            if (batchPrintOptionsSetting != null && !string.IsNullOrEmpty(batchPrintOptionsSetting.VALUE))
                BatchPrintOptions = batchPrintOptionsSetting.VALUE;

            var individualPrintOptionsSetting = SETTINGSManager.GetItemByRegistryName(CurrentUser, CurrentRegistryId, "EFRIndividualPrintOptions");
            if (individualPrintOptionsSetting != null && !string.IsNullOrEmpty(individualPrintOptionsSetting.VALUE))
                IndividualPrintOptions = individualPrintOptionsSetting.VALUE;
        }

        private void SetBreadCrumbLabelForBatchReport(LabResultsInterpretationLettersParameters letterParams)
        {
            switch (letterParams.ReportType)
            {
                case "11":
                    ReplacePageTitle("Print Completed Patient Letters - Biological Monitoring");
                    break;
                case "12":
                    ReplacePageTitle("Print Completed Provider Letters - Biological Monitoring");
                    break;
                case "13":
                    ReplacePageTitle("Print Completed Patient Letters - Fragment Analysis");
                    break;
                case "14":
                    ReplacePageTitle("Print Completed Provider Letters - Fragment Analysis");
                    break;
            }
        }

        private void SetupReport(LabResultsInterpretationLettersParameters letterParams)
        {
            const string BASE_REPORT_PATH = "/Reports/EFR/";

            ReportViewerLabResultsInterpretationLetters.Visible = false;

            ReportViewerLabResultsInterpretationLetters.Reset();

            reportViewerHandler.ClearParams();
            if (!letterParams.BatchReport)
            {
                reportViewerHandler.AddReportVariable("activityId", letterParams.ActivityID);
                reportViewerHandler.AddReportVariable("intActivityId", letterParams.IntActivityID);
                reportViewerHandler.AddReportVariable("reportType", letterParams.ReportType);
            }

            if (letterParams.BatchReport)
            {
                ReportViewerLabResultsInterpretationLetters.ServerReport.ReportPath = "InterpretationLettersMaster";
                switch (letterParams.ReportType)
                {
                    case "11":
                        ReportViewerLabResultsInterpretationLetters.ServerReport.ReportPath = "PatientBioLabIntrprtnLetterBatch";
                        break;
                    case "12":
                        ReportViewerLabResultsInterpretationLetters.ServerReport.ReportPath = "ProviderLabIntrprtnLetterBatch";
                        break;
                    case "13":
                        ReportViewerLabResultsInterpretationLetters.ServerReport.ReportPath = "PatientFragAnlyLabIntrprtnLetterBatch";
                        break;
                    case "14":
                        ReportViewerLabResultsInterpretationLetters.ServerReport.ReportPath = "ProviderFragAnlyLabIntrprtnLetterBatch";
                        break;
                }
            }
            // Bio Monitoring
            else if (int.Parse(HiddenFieldCaseTypeID.Value) == (int)WorkFlowTypes.Biomonitoring)
            {
                if (letterParams.ReportType == "0") // Patient
                    ReportViewerLabResultsInterpretationLetters.ServerReport.ReportPath = "PatientBioLabIntrprtnLetter";
                if (letterParams.ReportType == "1") // Provider
                    ReportViewerLabResultsInterpretationLetters.ServerReport.ReportPath = "ProviderLabIntrprtnLetter";
            }
            // Fragment Analysis
            else if (int.Parse(HiddenFieldCaseTypeID.Value) == (int)WorkFlowTypes.FragmentAnalysis)
            {
                if (letterParams.ReportType == "0") // Patient
                    ReportViewerLabResultsInterpretationLetters.ServerReport.ReportPath = "PatientFragAnlyLabIntrprtnLetter";
                if (letterParams.ReportType == "1") // Provider
                    ReportViewerLabResultsInterpretationLetters.ServerReport.ReportPath = "ProviderFragAnlyLabIntrprtnLetter";
            }

            ReportViewerLabResultsInterpretationLetters.ServerReport.ReportServerUrl = new Uri(ReportServerUrl);
            
            ReportViewerLabResultsInterpretationLetters.ServerReport.ReportPath = BASE_REPORT_PATH + ReportViewerLabResultsInterpretationLetters.ServerReport.ReportPath;

            reportViewerHandler.SetServerReportParameters(ReportViewerLabResultsInterpretationLetters);

            ReportViewerLabResultsInterpretationLetters.ProcessingMode = ProcessingMode.Remote;
            ReportViewerLabResultsInterpretationLetters.ServerReport.Refresh();
            ReportViewerLabResultsInterpretationLetters.Visible = true;
        }

        public static string GetConfigEntry(string key)
        {
            var value = string.Empty;

            if (WebConfigurationManager.AppSettings.Count > 0)
                value = WebConfigurationManager.AppSettings.Get(key);

            return value;
        }

        protected void Cancel_Click(object sender, EventArgs e)
        {
            RedirectToReferringPage();
        }
    }
}
